/*
*******************************************************************************
*
* File:         xmailbox.h
* Description:  mailboxing and PCI Interface functions that have no handle 
* Author:       Henrik Liebau
* Created:      09 Sep 1999, 09:15:31
* Modified:     Fri May 19 13:12:12 2000 by Henrik Liebau, BVS R&D
* Language:     C/C++ Include File
* Package:      E2920A series CAPI
* Status:       Confidential (do not distribute publicly)       
*
* (C) Copyright 1999 by Hewlett-Packard GmbH, All Rights Reserved.
*
*******************************************************************************
*/
 
#ifndef __xmailbox_h__
#define __xmailbox_h__

#include <xtypedef.h>

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************
   CAUTION:
   This function is a special CLI command, because it doesn't take a handle,
   and therefore currently isn't handled by the perl scripts. 
   If you change the parameters of this function, don't forget to
   adapt the file manuacli.h, too.
***************************************************************************/

#ifndef SWIG

bx_errtype EXPORT BestXDevIdentifierGet(  
  bx_int32      vendor_id,
  bx_int32      device_id,
  bx_int32      number,   
  bx_int32      *devid
);

bx_errtype EXPORT  BestXPCICfgMailboxSendRegWrite(
  bx_int32      devid,
  bx_int32      value,
  bx_int32      *status
);


bx_errtype EXPORT  BestXPCICfgMailboxReceiveRegRead(
  bx_int32      devid,
  bx_int32      *value,
  bx_int32      *status
);

#else

/* Prevent SWIG from applying its bx_errtype typemap 
   by replacing bx_errtype with bx_int32 */

bx_int32 EXPORT BestXDevIdentifierGet(  
  bx_int32      vendor_id,
  bx_int32      device_id,
  bx_int32      number,   
  bx_int32      *devid
);

bx_int32 EXPORT  BestXPCICfgMailboxSendRegWrite(
  bx_int32      devid,
  bx_int32      value,
  bx_int32      *status
);


bx_int32 EXPORT  BestXPCICfgMailboxReceiveRegRead(
  bx_int32      devid,
  bx_int32      *value,
  bx_int32      *status
);

#endif


#ifndef MAILBOX_ONLY
/* -----------------------------------------------------------------
 * Mailbox Register Functions 
 * ----------------------------------------------------------------- */

CLI bx_errtype EXPORT  BestXMailboxSendRegWrite(/* @mailboxsendregwrite */
  bx_handletype handle,
  bx_int32      val,
  bx_int32      *status      /* #RETURN "status = 0x%08lx" */
);

CLI bx_errtype EXPORT  BestXMailboxReceiveRegRead(/* @mailboxreceiveregread */
  bx_handletype handle,
  bx_int32      *val,    /* #RETURN "value  = 0x%08lx" */
  bx_int32      *status  /* #RETURN "status = 0x%08lx"    */
);

#endif /* not defined MAILBOX_ONLY */
  
#ifdef __cplusplus
}
#endif

#endif /* ndef __xmailbox_h__ */
